/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.mappingmode;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class SsoMappingModeEnvPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String mappingModeIsOpen = environment.getProperty("duiba.sso.mapping-mode", "false");
        if (!Boolean.valueOf(mappingModeIsOpen).booleanValue()) {
            return;
        }
        if (!application.isWebEnvironment()) {
            return;
        }
        String ssoUrl = environment.getProperty("duiba.sso.mapping-sso-url", "sso.duiba.com.cn");
        if (StringUtils.isBlank((String)ssoUrl)) {
            throw new SsoRunTimeException("\u914d\u7f6e:duiba.sso.mapping-sso-url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ssoUrl = ssoUrl.replace("http://", "");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sso-service.ribbon.listOfServers", ssoUrl);
        MapPropertySource propertySource = new MapPropertySource("ssoConfig", map);
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        mutablePropertySources.addFirst((PropertySource)propertySource);
    }
}

