/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.params.ApplicationInfoParams;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.properties.SpringApplicationProperties;
import cn.com.duiba.sso.api.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.SsoVersion;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;

public class SystemInfo
implements EnvironmentAware {
    private static Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private static volatile String systemAlias;
    private static volatile EnvironmentEnum environment;
    private static volatile String profiles;
    private static SsoSystemService ssoSystemService;
    private static RemoteSystemService remoteSystemService;
    @Autowired
    private SsoBasicProperties ssoBasicProperties;

    @EventListener(value={MainContextRefreshedEvent.class})
    public void MainContextRefreshedEventListener() {
        String version = SsoVersion.getVersion();
        ApplicationInfoParams params = new ApplicationInfoParams();
        params.setAppName(systemAlias);
        params.setVersion(version);
        params.setHomeUrl(this.ssoBasicProperties.getHomeUrl());
        remoteSystemService.submitApplicationInfoParams(params);
    }

    public static SystemDto getThisSystemInfo() {
        return ssoSystemService.getSystemByAlias(systemAlias);
    }

    public static Long getThisSystemId() {
        SystemDto system = SystemInfo.getThisSystemInfo();
        if (system == null) {
            throw new SsoRunTimeException("\u6ca1\u6709\u68c0\u7d22\u5230" + systemAlias + "\u5bf9\u5e94\u7684\u7cfb\u7edf\u914d\u7f6e");
        }
        return system.getId();
    }

    @Autowired
    public void setRemoteSystemService(RemoteSystemService remoteSystemService) {
        SystemInfo.remoteSystemService = remoteSystemService;
    }

    @Autowired
    public void setSpringApplicationProperties(SpringApplicationProperties springApplicationProperties) {
        systemAlias = Optional.ofNullable(springApplicationProperties.getPriorName()).orElse(springApplicationProperties.getName());
        if (StringUtils.isBlank((CharSequence)systemAlias)) {
            throw new SsoRunTimeException("Sso\u5ba2\u6237\u7aef\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u914d\u7f6e spring.application.name \u7cfb\u7edf\u522b\u540d");
        }
    }

    @Autowired
    public void setSsoSystemService(SsoSystemService ssoSystemService) {
        SystemInfo.ssoSystemService = ssoSystemService;
    }

    public static String getSystemAlias() {
        return systemAlias;
    }

    public static String getProfiles() {
        return profiles;
    }

    public static EnvironmentEnum getEnvironment() {
        return environment;
    }

    public void setEnvironment(Environment environment) {
        String profiles = environment.getProperty("spring.profiles.active", "dev");
        SystemInfo.environment = SystemInfo.parseEnvironmentEnum(profiles);
        SystemInfo.profiles = profiles;
    }

    public static EnvironmentEnum parseEnvironmentEnum(String profiles) {
        if (StringUtils.isBlank((CharSequence)profiles)) {
            return EnvironmentEnum.PROD;
        }
        if (StringUtils.startsWith((CharSequence)profiles, (CharSequence)"dev")) {
            return EnvironmentEnum.DEV;
        }
        if (StringUtils.startsWith((CharSequence)profiles, (CharSequence)"test")) {
            return EnvironmentEnum.TEST;
        }
        return EnvironmentEnum.PROD;
    }
}

