/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.mappingmode;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=2)
public class SsoMappingModeSleathPlugin
implements RequestInterceptor {
    @Autowired
    private Tracer tracer;

    @Around(value="execution(* cn.com.duiba.sso.api.remoteservice.*.*(..))")
    public Object invoke(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Class<?> clazz = joinPoint.getTarget().getClass();
        if (!this.tracer.isTracing() || !this.tracer.getCurrentSpan().isExportable()) {
            return joinPoint.proceed();
        }
        Span span = this.tracer.createSpan("sso:/" + methodName);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clazz.getSimpleName()).append(".").append(methodName);
        try {
            span.tag("sso.class_method", stringBuilder.toString());
            span.tag("lc", "sso-mappingmode");
            span.tag("peer.service", "sso-service");
            span.logEvent("cs");
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            span.logEvent("cr");
            this.tracer.close(span);
        }
    }

    public void apply(RequestTemplate template) {
        if (template.headers().containsKey("X-SSO-MR")) {
            template.header("X-B3-Flags", new String[]{"0"});
        }
    }
}

