/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.domain.enums;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ResourceType {
    POWER(1){

        @Override
        public void verify(String resourceText) {
            List urlList = spl.splitToList((CharSequence)resourceText);
            for (String url : urlList) {
                if (!StringUtils.isNotBlank((String)url) || pattern.matcher(url).find()) continue;
                throw new SsoRunTimeException(url + "\u4e0d\u7b26\u5408/**/**...\u7684\u683c\u5f0f");
            }
        }
    }
    ,
    JSON(2){

        @Override
        public void verify(String resourceText) {
            JSONObject json;
            try {
                json = JSONObject.parseObject((String)resourceText);
            }
            catch (Exception e) {
                logger.debug("\u8d44\u6e90\u5185\u5bb9\u4e0d\u7b26\u5408JSON\u683c\u5f0f", (Throwable)e);
                throw new SsoRunTimeException("\u8d44\u6e90\u5185\u5bb9\u4e0d\u7b26\u5408JSON\u683c\u5f0f");
            }
            if (json.containsKey((Object)ResourceType.POWER_KEYS)) {
                POWER.verify(json.getString(ResourceType.POWER_KEYS));
            }
        }
    };

    private static Splitter spl;
    private static Logger logger;
    private static Pattern pattern;
    public static final String POWER_KEYS = "keys";
    private final Integer type;

    public static ResourceType getResourceType(Integer type) {
        switch (type) {
            case 1: {
                return POWER;
            }
            case 2: {
                return JSON;
            }
        }
        throw new SsoRunTimeException("\u975e\u6709\u6548\u7684\u8d44\u6e90\u7c7b\u578b");
    }

    private ResourceType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }

    public abstract void verify(String var1);

    static {
        spl = Splitter.on((String)",").omitEmptyStrings().trimResults();
        logger = LoggerFactory.getLogger(ResourceType.class);
        pattern = Pattern.compile("^(/?[A-Za-z0-9]*)+$");
    }
}

