package cn.com.duiba.sso.api.mappingmode;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

import java.util.HashMap;
import java.util.Map;

public class SsoMappingModeEnvPostProcessor implements EnvironmentPostProcessor {

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {

        String mappingModeIsOpen = environment.getProperty("duiba.sso.mapping-mode","false");
        if(!Boolean.valueOf(mappingModeIsOpen)){
            return;
        }
        if(!application.isWebEnvironment()){//判断到是bootstrap的application则跳过
            return;
        }
        String appName = environment.getProperty("spring.application.name");
        if(StringUtils.equals("sso-service",appName)){
            return;
        }

        String ssoUrl = environment.getProperty("duiba.sso.mapping-sso-url","sso.duiba.com.cn");
        String appSecret = environment.getProperty("duiba.sso.app-secret");

        if(StringUtils.isBlank(ssoUrl)){
            throw new SsoRunTimeException("配置:duiba.sso.mapping-sso-url不能为空");
        }
        if(StringUtils.isBlank(appSecret)){
            throw new SsoRunTimeException("SSO映射模式必须配置:duiba.sso.app-secret");
        }
        ssoUrl = ssoUrl.replace("http://","");
        Map<String, Object> map = new HashMap<>();
        map.put("sso-service.ribbon.listOfServers",ssoUrl);

        PropertySource<?> propertySource = new MapPropertySource("ssoConfig",map);
        //最后的优先级最低
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        mutablePropertySources.addFirst(propertySource);
    }
}
