package cn.com.duiba.sso.api.mappingmode;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

@Aspect
public class SsoMappingModeSleathPlugin{

    @Autowired
    private Tracer tracer;

    @Around("execution(* cn.com.duiba.sso.api.remoteservice.*.*(..))")
    public Object invoke(ProceedingJoinPoint joinPoint) throws Throwable {

        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Class<?> clazz = joinPoint.getTarget().getClass();

        if(!tracer.isTracing() || !tracer.getCurrentSpan().isExportable()){
            return joinPoint.proceed();
        }

        Span span = tracer.createSpan("sso:/"+methodName);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clazz.getSimpleName()).append(".").append(methodName);
        try {
            span.tag("sso.class_method", stringBuilder.toString());// get/...
            span.tag(Span.SPAN_LOCAL_COMPONENT_TAG_NAME, "sso-mappingmode");//本地组件名
            span.tag(Span.SPAN_PEER_SERVICE_TAG_NAME, "sso-service");//远程服务名
            span.logEvent(Span.CLIENT_SEND);

            return joinPoint.proceed();
        } catch(Exception e){
            throw e;
        } finally {
            span.logEvent(Span.CLIENT_RECV);
            this.tracer.close(span);
        }


    }


}
