package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.mappingmode.SsoMappingModePlugin;
import cn.com.duiba.sso.api.mappingmode.SsoMappingModeSleathPlugin;
import cn.com.duiba.sso.api.domain.properties.SpringApplicationProperties;
import cn.com.duiba.sso.api.domain.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.service.eventbus.SsoEventBus;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerService;
import cn.com.duiba.sso.api.service.power.AdminPowerService;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.SystemInfo;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.Span;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

@Configuration
@EnableConfigurationProperties({SpringApplicationProperties.class,SsoBasicProperties.class})
@ComponentScan("cn.com.duiba.sso.api")
@ImportResource("classpath:sso-common-task.xml")
public class SsoBasicConfiguration {

    @Bean
    public SystemInfo initSysytem(){
        return new SystemInfo();
    }

    @Configuration
    @ConditionalOnClass(Aspect.class)
    @ConditionalOnProperty(name="duiba.sso.mapping-mode", havingValue="true")
    public static class SsoMappingModeConfiguration{

        @Bean
        public SsoMappingModePlugin ssoMappingModePlugin(){
            return new SsoMappingModePlugin();
        }

        @Bean
        @ConditionalOnClass(Span.class)
        public SsoMappingModeSleathPlugin ssoMappingModeSleathPlugin(){
            return new SsoMappingModeSleathPlugin();
        }
    }

    @Bean
    public SsoSystemService ssoSystemService(){
        return new SsoSystemService();
    }

    @Bean
    public PowerTreeService powerTreeService(){
        return new PowerTreeService();
    }

    @Bean
    public AdminPowerService adminPowerService(){
        return new AdminPowerService();
    }

    @Bean
    public SsoLoggerService ssoLoggerService(){
        return new SsoLoggerService();
    }

    @Bean
    public SsoEventBus ssoEventBus(){
        return new SsoEventBus();
    }

}
