package cn.com.duiba.sso.api.mappingmode;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import org.apache.commons.lang.StringUtils;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

import java.util.HashMap;
import java.util.Map;

public class SsoMappingModeEnvApplicationInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext>, Ordered {

    @Override
    public void initialize(ConfigurableApplicationContext application) {

        ConfigurableEnvironment environment = application.getEnvironment();
        String mappingMode = environment.getProperty("duiba.sso.mapping-mode","false");
        if(!Boolean.valueOf(mappingMode)){
            return;
        }

        String appName = environment.getProperty("spring.application.name");
        if(StringUtils.equals("sso-service",appName)){
            return;
        }

        String ssoUrl = environment.getProperty("duiba.sso.mapping-sso-url","sso.duiba.com.cn:443");
        String appSecret = environment.getProperty("duiba.sso.app-secret");

        if(StringUtils.isBlank(ssoUrl)){
            throw new SsoRunTimeException("配置:duiba.sso.mapping-sso-url不能为空");
        }
        if(StringUtils.isBlank(appSecret)){
            throw new SsoRunTimeException("SSO映射模式必须配置:duiba.sso.app-secret");
        }
        ssoUrl = ssoUrl.replace("http://","");
        Map<String, Object> map = new HashMap<>();
        map.put("sso-service.ribbon.listOfServers",ssoUrl);
        //map.put("duiba.feign.serialization","hessian2");//XXS会对json进行转义  2.3.21

        PropertySource<?> propertySource = new MapPropertySource("ssoConfig",map);
        //最后的优先级最低
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        mutablePropertySources.addFirst(propertySource);


        ApplicationContext parent = application.getParent();
        if (parent != null) {
            parent.publishEvent(new EnvironmentChangeEvent(map.keySet()));
        }
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE + 20;
    }
}
