package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.params.ApplicationInfoParams;

import java.util.Map;
import java.util.Set;

/**
 * Created by liuyao on 2017/12/5.
 */
@AdvancedFeignClient
public interface RemoteSystemService {

    void createApp(SystemDto app) throws BizException;
    /**
     * 根据系统别名获取系统信息
     * @param appNameAlias 系统别名
     * @return 应用配置
     */
    SystemDto getSystemByAlias(String appNameAlias);

    /**
     * 提交版本号
     */
    void submitSsoVersion(Long systemId,String version);
    /**
     * 提交版本号
     */
    void updateSsoVersion(String appNameAlias,String version);
    /**
     * 提交应用信息
     */
    void submitApplicationInfoParams(ApplicationInfoParams params);

    /**
     * 获取sso系统版本号
     * @param appNameAliasSet 系统别名集合
     * @return （appNameAlias -> version）
     */
    Map<String,String> findSsoSystemVersionMap(Set<String> appNameAliasSet);

    /**
     * 获取系统域名
     * @param appNameAliasSet 系统别名集合
     * @return appNameAlias -> homeUrl）
     */
    Map<String,String> findAppHomeUrlMap(String profiles,Set<String> appNameAliasSet);

}
