/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.system;

import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duiba.wolf.utils.UrlUtils;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SsoSystemService {
    private static final String SSO_SERVER_NAME = "sso-service";
    private Logger logger = LoggerFactory.getLogger(SsoSystemService.class);
    @Autowired
    private RemoteSystemService remoteSystemService;
    private LoadingCache<String, SystemDto> cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(systemName -> {
        SystemDto systemDto = this.remoteSystemService.getSystemByAlias((String)systemName);
        if (systemDto == null) {
            this.logger.error("systemName:" + systemName + "\u6ca1\u6709\u5bf9\u5e94\u7684\u7cfb\u7edf\u914d\u7f6e");
        }
        return systemDto;
    });

    public SystemDto getSystemByAlias(String systemAlias) {
        return (SystemDto)this.cache.get((Object)systemAlias);
    }

    public String getSsoHomeUrl() {
        return this.getSystemByAlias(SSO_SERVER_NAME).getHomeUrl();
    }

    public String buildOauth2Url(String url) {
        try {
            String redirect = URLEncoder.encode(url, "utf-8");
            String state = UUIDUtils.createSecureUUID();
            HashMap params = Maps.newHashMap();
            params.put("redirect", redirect);
            params.put("state", state);
            return UrlUtils.appendParams((String)(this.getSsoHomeUrl() + "/sso/oauth2/authorize"), (Map)params);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaOauth2\u8bf7\u6c42\u5730\u5740\u5931\u8d25", (Throwable)e);
            throw new SsoRunTimeException(e);
        }
    }
}

