package cn.com.duiba.sso.api.service.system;

import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duiba.wolf.utils.UrlUtils;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SsoSystemService {

    private static final String SSO_SERVER_NAME = "sso-service";

    private Logger logger = LoggerFactory.getLogger(SsoSystemService.class);

    @Autowired
    private RemoteSystemService remoteSystemService;

    private LoadingCache<String, SystemDto> cache = Caffeine.newBuilder()
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build((systemName)->{
                SystemDto systemDto = remoteSystemService.getSystemByAlias(systemName);
                if(systemDto==null){
                    logger.error("systemName:"+systemName+"没有对应的系统配置");
                }
                return systemDto;
            });

    public SystemDto getSystemByAlias(String systemAlias){
        return cache.get(systemAlias);
    }

    public String getSsoHomeUrl(){
        return getSystemByAlias(SSO_SERVER_NAME).getHomeUrl();
    }

    /**
     * 构建Oauth2请求地址
     * @param url
     * @return
     */
    public String buildOauth2Url(String url){

        try{
            String redirect = URLEncoder.encode(url,"utf-8");
            String state = UUIDUtils.createSecureUUID();

            Map<String,String> params = Maps.newHashMap();
            params.put("redirect",redirect);
            params.put("state",state);

            return UrlUtils.appendParams(getSsoHomeUrl()+"/sso/oauth2/authorize",params);

        }catch (Exception e){
            logger.error("构建Oauth2请求地址失败",e);
            throw new SsoRunTimeException(e);
        }

    }
}
