/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.mappingmode;

import cn.com.duiba.sso.api.domain.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.mappingmode.MappingModeRequestMateInfo;
import cn.com.duiba.sso.api.service.system.EnvironmentDecisionMaker;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import cn.com.duiba.sso.api.tool.SignTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.google.common.collect.Maps;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class SsoMappingModePlugin
implements RequestInterceptor {
    private Logger logger = LoggerFactory.getLogger(SsoMappingModePlugin.class);
    @Autowired
    private SsoBasicProperties ssoBasicProperties;
    @Autowired
    private EnvironmentDecisionMaker environmentDecisionMaker;
    private static ThreadLocal<Boolean> SSO_INVOKE_FLAG = new TransmittableThreadLocal();
    public static final String SSO_RPC_MR = "X-SSO-MR";
    public static final String SSO_RPC_SIGN = "X-SSO-SIGN";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(RequestTemplate template) {
        try {
            Boolean flag = Optional.ofNullable(SSO_INVOKE_FLAG.get()).orElse(false);
            if (!flag.booleanValue()) {
                return;
            }
            MappingModeRequestMateInfo mateInfo = new MappingModeRequestMateInfo();
            mateInfo.setSystemName(SystemInfo.getSystemAlias());
            mateInfo.setInterfaceName(template.url());
            mateInfo.setTimestamp(System.currentTimeMillis());
            EnvironmentEnum environment = this.environmentDecisionMaker.getEnvironmentEnum();
            mateInfo.setProfiles(environment.getName());
            if (StringUtils.isBlank((String)this.ssoBasicProperties.getAppSecret())) {
                throw new SsoRunTimeException("\u542f\u52a8SSO\u6620\u5c04\u6a21\u5f0f\u5fc5\u987b\u914d\u7f6eduiba.sso.app-secret");
            }
            String sign = SsoMappingModePlugin.createSign(this.ssoBasicProperties.getAppSecret(), mateInfo);
            mateInfo.setSign(sign);
            String rpcJson = JSONObject.toJSONString((Object)mateInfo);
            template.header(SSO_RPC_MR, new String[]{"true"});
            template.header(SSO_RPC_SIGN, new String[]{URLEncoder.encode(rpcJson, "UTF-8")});
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("json\u7f16\u7801\u51fa\u9519", (Throwable)e);
        }
        finally {
            SSO_INVOKE_FLAG.remove();
        }
    }

    @Before(value="execution(* cn.com.duiba.sso.api.remoteservice.*.*(..))")
    public void mappingModeRoute() {
        SSO_INVOKE_FLAG.set(this.ssoBasicProperties.getMappingMode() != false && !StringUtils.equals((String)"sso-service", (String)SystemInfo.getSystemAlias()));
    }

    public static String createSign(String appSecret, MappingModeRequestMateInfo mateInfo) {
        HashMap params = Maps.newHashMap();
        params.put("systemName", mateInfo.getSystemName());
        params.put("interfaceName", mateInfo.getInterfaceName());
        params.put("profiles", mateInfo.getProfiles());
        params.put("timestamp", mateInfo.getTimestamp().toString());
        return SignTool.sign(appSecret, params);
    }
}

