/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.power;

import cn.com.duiba.sso.api.common.tree.Tree;
import cn.com.duiba.sso.api.common.tree.TreeFactory;
import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.service.power.PowerTreeCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PowerTreeService {
    private static Logger logger = LoggerFactory.getLogger(PowerTreeService.class);
    @Autowired
    private RemotePermissionService remotePermissionService;
    private LoadingCache<Long, PowerTreeCache> treeCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build(systemId -> {
        List<PowerDto> treeList = this.remotePermissionService.loadPowerList((Long)systemId);
        Tree<PowerDto> tree = TreeFactory.createTree(treeList);
        HashMultimap urlMap = HashMultimap.create();
        for (PowerDto power : treeList) {
            for (String url : power.getUrls()) {
                urlMap.put((Object)url, (Object)power.getId());
            }
        }
        return new PowerTreeCache(tree, (HashMultimap<String, Long>)urlMap);
    });

    public PowerTreeCache getPowerTreeCache(Long systemId) {
        try {
            return (PowerTreeCache)this.treeCache.get((Object)systemId);
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7dsystemId:" + systemId + "\u7684\u8d44\u6e90\u5f02\u5e38", (Throwable)e);
            throw new SsoRunTimeException("\u8d44\u6e90\u52a0\u8f7d\u5931\u8d25");
        }
    }

    public void powerTreeFlushTask() {
        Set systemIds = this.treeCache.asMap().keySet();
        for (Long systemId : systemIds) {
            try {
                Long version = this.remotePermissionService.getSystemPowerVersion(systemId);
                PowerTreeCache cache = (PowerTreeCache)this.treeCache.getIfPresent((Object)systemId);
                if (cache == null || cache.getVersion() >= version) continue;
                this.treeCache.invalidate((Object)systemId);
            }
            catch (Exception e) {
                logger.error("\u6743\u9650\u8d44\u6e90\u68c0\u67e5\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

