/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignTool {
    private static final Logger log = LoggerFactory.getLogger(SignTool.class);
    private static final Set<String> IGNORE_KEYS = new HashSet<String>();
    private static final Long TIME_OUT = 180000L;

    public static void signVerify(String appSecret, Map<String, String> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        Set<String> keys = params.keySet();
        for (String key : keys) {
            if (IGNORE_KEYS.contains(key)) continue;
            map.put(key, params.get(key));
        }
        String sign = SignTool.sign(appSecret, map);
        if (!StringUtils.equals((String)sign, (String)params.get("sign"))) {
            throw new SsoRunTimeException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String sign(String appSecret, Map<String, String> params) {
        if (StringUtils.isBlank((String)appSecret)) {
            throw new SsoRunTimeException("\u7f3a\u5931\u79d8\u94a5");
        }
        if (!params.containsKey("timestamp")) {
            throw new SsoRunTimeException("\u53c2\u6570\u7f3a\u5c11\u65f6\u95f4\u6233");
        }
        Long timestamp = Long.valueOf(params.get("timestamp"));
        Long now = new Date().getTime();
        long def = now - timestamp;
        if (Math.abs(def) > TIME_OUT) {
            throw new SsoRunTimeException("\u7b7e\u540d\u5931\u6548");
        }
        HashMap sourceMap = Maps.newHashMap();
        sourceMap.put("appSecret", appSecret);
        sourceMap.putAll(params);
        ArrayList keys = Lists.newArrayList(sourceMap.keySet());
        Collections.sort(keys);
        StringBuilder stringBuilder = new StringBuilder();
        for (String s : keys) {
            stringBuilder.append((String)sourceMap.get(s));
        }
        try {
            String src = stringBuilder.toString();
            return SignTool.toHexValue(SignTool.encryptMD5(src.getBytes("utf-8")));
        }
        catch (Exception e) {
            log.error("md5 error", (Throwable)e);
            throw new SsoRunTimeException(e);
        }
    }

    private static byte[] encryptMD5(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    static {
        IGNORE_KEYS.add("sign");
        IGNORE_KEYS.add("appSecret");
    }
}

