package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.params.AppInterfaceInfoParams;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAppInterfaceInfoService {


    /**
     * 向sso申请提交接口信息
     * @param appNameAlias 系统别名
     * @return 用于提交的版本
     * @throws BizException 未申请成功
     */
    Long tryBeginSubmitInterfaceInfo(String appNameAlias) throws BizException;

    /**
     * 提交接口信息
     * @param appNameAlias 系统别名
     * @param version 提交的版本
     * @param interfaceInfos 接口信息
     * @return 提交成功的条目数
     */
    Integer submitInterfaceInfo(String appNameAlias, Long version, List<AppInterfaceInfoParams> interfaceInfos) throws BizException;

    /**
     * 结束提交
     * @param appNameAlias 系统别名
     */
    void endSubmit(String appNameAlias,Long version) throws BizException;

    /**
     * 回滚当前的提交
     * @param appNameAlias 系统别名
     */
    void rollback(String appNameAlias,Long version);

}
