package cn.com.duiba.sso.api.service.system;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

public enum EnvironmentEnum {

    DEV(1L,"dev","开发环境"),
    TEST(2L,"test","测试环境"),
    ALI_TEST(2L,"test01","阿里测试环境"),
    PRE(3L,"pre","预发环境"),
    PROD(3L,"prod","生产环境");//预发和线上共用资源，所以envId相同

    private final Long envId;
    private final String name;
    private final String envName;

    EnvironmentEnum(Long envId,String name,String envName){
        this.envId = envId;
        this.name = name;
        this.envName = envName;
    }

    public Long getEnvId() {
        return envId;
    }

    public String getName() {
        return name;
    }

    public String getEnvName() {
        return envName;
    }

    public static EnvironmentEnum getEnvByName(String name){
        Objects.requireNonNull(name);
        switch (name){
            case "dev":return DEV;
            case "test":return TEST;
            case "prod":return PROD;
            case "pre":return PRE;
            default:throw new SsoRunTimeException("环境变量解析失败");
        }
    }

    public static EnvironmentEnum getEnvById(Long id){
        switch (id.intValue()){
            case 1:return DEV;
            case 2:return TEST;
            case 3:return PROD;
            default:throw new SsoRunTimeException("环境变量解析失败");
        }
    }

    public static EnvironmentEnum getEnvByPrefix(String prefix){
        for(EnvironmentEnum env:EnvironmentEnum.values()){
            if(StringUtils.startsWith(prefix,env.getName())){
                return env;
            }
        }
        return null;
    }

    public static Boolean isOnline(EnvironmentEnum environment){
        return Objects.equals(environment,EnvironmentEnum.PROD) || Objects.equals(environment,EnvironmentEnum.PRE);
    }

    public static EnvironmentEnum parseEnvironmentEnum(String profiles){
        if(org.apache.commons.lang3.StringUtils.isBlank(profiles)){
            return EnvironmentEnum.PROD;
        }
        for(EnvironmentEnum environmentEnum:EnvironmentEnum.values()){
            if(StringUtils.startsWith(profiles,environmentEnum.getName())){
                return environmentEnum;
            }
        }
        return EnvironmentEnum.PROD;
    }
}
