package cn.com.duiba.sso.api.domain.properties;

import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * sso映射模式
 */
@ConfigurationProperties(prefix = "duiba.sso")
public class SsoBasicProperties {

    /**
     * 接入sso服务的秘钥
     */
    private String appSecret;

    private String homeUrl;
    /**
     * 是否开启映射模式
     */
    private Boolean mappingMode = false;
    /**
     * 映射的服务地址
     */
    private String mappingSsoUrl;
    /**
     * 指定映射环境
     * 指定后，appSecret要和对应环境的秘钥保持一致
     */
    private EnvironmentEnum environment;

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getHomeUrl() {
        return homeUrl;
    }

    public void setHomeUrl(String homeUrl) {
        this.homeUrl = homeUrl;
    }

    public Boolean getMappingMode() {
        return mappingMode;
    }

    public void setMappingMode(Boolean mappingMode) {
        this.mappingMode = mappingMode;
    }

    public String getMappingSsoUrl() {
        return mappingSsoUrl;
    }

    public void setMappingSsoUrl(String mappingSsoUrl) {
        this.mappingSsoUrl = mappingSsoUrl;
    }

    public EnvironmentEnum getEnvironment() {
        return environment;
    }

    public void setEnvironment(EnvironmentEnum environment) {
        this.environment = environment;
    }
}
