package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.BusinessLineDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteBusinessLineService {

    /**
     * 获取所有的业务线
     * @return
     */
    List<BusinessLineDto> findAllBusinessLine();

    /**
     * 获取产线负责人列表
     * @param bolId 业务线Id
     * @return 负责人Id
     */
    List<Long> findBusinessLineManagers(Long bolId);

    /**
     * 获取产线下管控的应用集合
     * @param bolId 业务线别名
     * @return 业务线的配置集合
     */
    List<String> findBolAppList(Long bolId);


}
