package cn.com.duiba.sso.api.service.system;

import com.alibaba.ttl.TransmittableThreadLocal;

import javax.annotation.Resource;
import java.util.Optional;

public class DefaultEnvironmentDecisionMaker implements EnvironmentDecisionMaker{

    private static TransmittableThreadLocal<EnvironmentEnum> SSO_ENV = new TransmittableThreadLocal<>();

    @Resource
    private EnvironmentEnum defaultEnvironmentEnum;
    /**
     * 获取当前的环境
     * 1.映射模式
     * 2.域名判断
     * @return 当前的请求的环境内容
     */
    @Override
    public EnvironmentEnum getEnvironmentEnum(){
        return Optional.ofNullable(SSO_ENV.get()).orElse(getSsoEnvironmentEnum());
    }

    public final EnvironmentEnum getSsoEnvironmentEnum(){
        return defaultEnvironmentEnum;
    }

    public final void setEnvironment(EnvironmentEnum mateInfo){
        SSO_ENV.set(mateInfo);
    }

    public final void clear(){
        SSO_ENV.remove();
    }

}
