/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.system;

import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SsoSystemService {
    private static final String SSO_SERVER_NAME = "sso-service";
    private Logger logger = LoggerFactory.getLogger(SsoSystemService.class);
    @Autowired
    private RemoteSystemService remoteSystemService;
    private LoadingCache<String, SystemDto> cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(systemName -> {
        SystemDto systemDto = this.remoteSystemService.getSystemByAlias(systemName);
        if (systemDto == null) {
            this.logger.error("systemName:" + systemName + "\u6ca1\u6709\u5bf9\u5e94\u7684\u7cfb\u7edf\u914d\u7f6e");
        }
        return systemDto;
    });

    public SystemDto getSystemByAlias(String systemAlias) {
        return (SystemDto)this.cache.get((Object)systemAlias);
    }

    public String getSsoHomeUrl() {
        return this.getSystemByAlias(SSO_SERVER_NAME).getHomeUrl();
    }
}

