package cn.com.duiba.sso.api.config;

import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

import java.util.HashMap;
import java.util.Map;

public class SsoExecutorServiceInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext>, Ordered {

    public static final String SSO_THREAD_POOL_NAME = "$ssoExecutorService";

    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {

        ConfigurableEnvironment environment = applicationContext.getEnvironment();

        Map<String, Object> map = new HashMap<>();
        map.put("duiba.threadpool.enabled",true);
        map.put("duiba.threadpool.extra."+SSO_THREAD_POOL_NAME+".core-size",5);
        map.put("duiba.threadpool.extra."+SSO_THREAD_POOL_NAME+".max-size",20);
        map.put("duiba.threadpool.extra."+SSO_THREAD_POOL_NAME+".queue-size",100);

        PropertySource<?> propertySource = new MapPropertySource("ssoExecutorServiceConfig",map);
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        mutablePropertySources.addFirst(propertySource);

    }

    @Override
    public int getOrder() {
        return 0;
    }
}