package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.ApplicationOwnerConfigDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.params.ApplicationInfoParams;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by liuyao on 2017/12/5.
 */
@AdvancedFeignClient
public interface RemoteSystemService {

    /**
     * 在本地启动的开发环境，如果版本没有检测成功，直接启动失败，在控制台返回 BizException 信息
     * @throws BizException 检测失败信息
     */
    void checkAppVersion(String extVersion,String ssoVersion) throws BizException;

    /**
     * 创建应用
     **/
    void createApp(SystemDto app) throws BizException;
    /**
     * 根据系统别名获取系统信息
     * @param appNameAlias 系统别名
     * @return 应用配置
     */
    SystemDto getSystemByAlias(String appNameAlias);

    List<SystemDto> findAllSystem();

    /**
     * 提交版本号
     */
    void submitSsoVersion(Long systemId,String version);
    /**
     * 提交版本号
     */
    void updateSsoVersion(String appNameAlias,String version);
    /**
     * 提交应用信息
     */
    void submitApplicationInfoParams(ApplicationInfoParams params);

    /**
     * 获取sso系统版本号
     * @param appNameAliasSet 系统别名集合
     * @return （appNameAlias -> version）
     */
    Map<String,String> findSsoSystemVersionMap(Set<String> appNameAliasSet);

    /**
     * 获取系统域名
     * @param appNameAliasSet 系统别名集合
     * @return appNameAlias -> homeUrl）
     */
    Map<String,String> findAppHomeUrlMap(String profiles,Set<String> appNameAliasSet);

    /**
     * 查询一个用户关心的应用列表
     * @param adminId 用户Id
     * @return 系统别名集合
     */
    Set<String> findConcernApps(Long adminId);
    /**
     * 添加应用关注
     * @param adminId 用户Id
     * @param appAlias 需要关注的系统
     */
    void addConcernApp(Long adminId,String appAlias);
    void cancelConcernApp(Long adminId,String appAlias);

    /**
     * 获取应用的owners
     * @param appAlias 应用别名
     * @return owner列表
     */
    Set<Long> findOwnersByAppAlias(String appAlias);

    /**
     * 批量获取应用的owner信息
     * @return
     */
    List<ApplicationOwnerConfigDto> batchFindAppOwners(List<String> appAliasList);

    /**
     * 获取应用的成员
     * @param appAlias 应用别名
     * @return 成员列表
     */
    Set<Long> findMembersByAppAlias(String appAlias);

    /**
     * 获取一个admin担任成员的所有app
     */
    Set<String> findAppAliasByMemberId(Long adminId);

}
