package cn.com.duiba.sso.api.service.system;

import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duiba.wolf.utils.UrlUtils;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SsoSystemService {

    private Logger logger = LoggerFactory.getLogger(SsoSystemService.class);

    @Autowired
    private RemoteSystemService remoteSystemService;

    private LoadingCache<String, SystemDto> cache = Caffeine.newBuilder()
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build((systemName)->{
                SystemDto systemDto = remoteSystemService.getSystemByAlias(systemName);
                if(systemDto==null){
                    logger.error("systemName:"+systemName+"没有对应的系统配置");
                }
                return systemDto;
            });

    public SystemDto getSystemByAlias(String systemAlias){
        return cache.get(systemAlias);
    }


}
