package cn.com.duiba.sso.api.mappingmode;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

import java.util.HashMap;
import java.util.Map;

/**
 * 兼容老版本的映射模式
 */
public class SsoMappingModeEnvApplicationInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext>, Ordered {

    @Override
    public void initialize(ConfigurableApplicationContext application) {

        ConfigurableEnvironment environment = application.getEnvironment();

        MutablePropertySources mutablePropertySources = environment.getPropertySources();

        Map<String, Object> baseConfig = new HashMap<>();
        PropertySource<?> basePropertySource = new MapPropertySource("ssoBaseConfig",baseConfig);
        mutablePropertySources.addFirst(basePropertySource);

        //baseConfig.put("application.boot.oauth.host","https://oauth.dui88.com");
        String environmentForConfig = environment.getProperty("duiba.sso.environment","");
        if(StringUtils.isNotBlank(environmentForConfig)){
            baseConfig.put("spring.application.environment",environmentForConfig);
        }

        String mappingMode = environment.getProperty("duiba.sso.mapping-mode","false");
        if(!Boolean.valueOf(mappingMode)){
            return;
        }
        String appName = environment.getProperty("spring.application.name");
        if(StringUtils.equals("sso-service",appName)){
            return;
        }

        String ssoUrl = environment.getProperty("duiba.sso.mapping-sso-url","sso.duiba.com.cn:443");
        String appSecret = environment.getProperty("duiba.sso.app-secret");

        if(StringUtils.isBlank(ssoUrl)){
            throw new SsoRunTimeException("配置:duiba.sso.mapping-sso-url不能为空");
        }
        if(StringUtils.isBlank(appSecret)){
            throw new SsoRunTimeException("SSO映射模式必须配置:duiba.sso.app-secret");
        }
        ssoUrl = ssoUrl.replace("http://","");
        Map<String, Object> map = new HashMap<>();
        map.put("application.boot.mapping-mode.sso-service",ssoUrl);
        map.put("application.boot.mapping-mode.application-boot","oauth.dui88.com:443");

        map.put("spring.application.secret",appSecret);

        PropertySource<?> propertySource = new MapPropertySource("ssoMappingModeConfig",map);
        //最后的优先级最低
        mutablePropertySources.addFirst(propertySource);

    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE + 10;
    }
}
