/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.mappingmode;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class SsoMappingModeEnvApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public void initialize(ConfigurableApplicationContext application) {
        ConfigurableEnvironment environment = application.getEnvironment();
        String appName = environment.getProperty("spring.application.name");
        if (StringUtils.equals((String)"sso-service", (String)appName)) {
            return;
        }
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        HashMap<String, String> baseConfig = new HashMap<String, String>();
        MapPropertySource basePropertySource = new MapPropertySource("ssoBaseConfig", baseConfig);
        mutablePropertySources.addFirst((PropertySource)basePropertySource);
        String environmentForConfig = environment.getProperty("duiba.sso.environment", "");
        String environmentForMapping = environment.getProperty("spring.application.environment", "");
        if (StringUtils.isNotBlank((String)environmentForConfig) && StringUtils.isBlank((String)environmentForMapping)) {
            baseConfig.put("spring.application.environment", environmentForConfig);
        }
        String appSecret = environment.getProperty("duiba.sso.app-secret");
        String secret = environment.getProperty("spring.application.secret");
        if (StringUtils.isBlank((String)secret) && StringUtils.isNotBlank((String)appSecret)) {
            baseConfig.put("spring.application.secret", appSecret);
        }
    }

    public int getOrder() {
        return -2147483638;
    }
}

