/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.common.interfaces;

import cn.com.duiba.sso.api.common.interfaces.AppInterfaceAnalysisService;
import cn.com.duiba.sso.api.common.interfaces.MethodInfoAnalysis;
import cn.com.duiba.sso.api.common.interfaces.analysis.SsoLoggerMethodInfoAnalysis;
import cn.com.duiba.sso.api.common.interfaces.analysis.SwaggerMethodInfoAnalysis;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppInterfaceAnalysisConfiguration {
    @Bean
    public AppInterfaceAnalysisService appInterfaceAnalysisService(List<MethodInfoAnalysis> analyses) {
        AppInterfaceAnalysisService service = new AppInterfaceAnalysisService();
        service.setAnalysisList(Lists.reverse(analyses));
        return service;
    }

    @Bean
    public SsoLoggerMethodInfoAnalysis ssoLoggerMethodInfoAnalysis() {
        return new SsoLoggerMethodInfoAnalysis();
    }

    @Configuration
    @ConditionalOnClass(value={ApiOperation.class})
    public static class SwaggerMethodInfoAnalysisConfiguration {
        @Bean
        public SwaggerMethodInfoAnalysis swaggerMethodInfoAnalysis() {
            return new SwaggerMethodInfoAnalysis();
        }
    }
}

