/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.common.tree;

import cn.com.duiba.sso.api.common.tree.TreeNode;
import cn.com.duiba.sso.api.common.tree.TreeNodeShim;
import cn.com.duiba.sso.api.exception.SsoException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class Tree<T extends TreeNodeShim>
implements Serializable {
    private TreeNode rootNode;
    private Map<Long, T> objMap = Maps.newHashMap();
    private transient ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public Tree() {
        this.rootNode = new TreeNode(0L, TreeNode.VIRTUAL_PARENT_ID);
    }

    public Tree(Long rootId) {
        this.rootNode = new TreeNode(rootId, TreeNode.VIRTUAL_PARENT_ID);
    }

    public boolean containsId(Long id) {
        return this.rootNode.containsId(id);
    }

    public int size() {
        return this.rootNode.getChildSize();
    }

    public void addNode(T shim) {
        try {
            this.readWriteLock.writeLock().lock();
            TreeNode node = new TreeNode(((TreeNodeShim)shim).getId(), ((TreeNodeShim)shim).getParentId(), ((TreeNodeShim)shim).getWeight());
            this.rootNode.addChildNode(node);
            ((TreeNodeShim)shim).setLevel(node.getLevel());
            this.objMap.put(((TreeNodeShim)shim).getId(), shim);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void deleteNode(Long nodeId) throws Exception {
        try {
            this.readWriteLock.writeLock().lock();
            if (this.rootNode.containsId(nodeId)) {
                this.rootNode.deleteChildNode(nodeId);
                this.objMap.remove(nodeId);
            }
        }
        catch (Exception e) {
            throw new SsoException(e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public List<T> getTreeView() {
        try {
            this.readWriteLock.readLock().lock();
            List<TreeNode> list = this.rootNode.getAllNode();
            List list2 = list.stream().map(node -> (TreeNodeShim)this.objMap.get(node.getId())).collect(Collectors.toList());
            return list2;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public T getNode(Long nodeId) {
        return (T)((TreeNodeShim)this.objMap.get(nodeId));
    }

    public List<T> getOneWayView(Long destNodeId) {
        ArrayList idSequence = Lists.newArrayList();
        this.rootNode.findNodeWay(destNodeId, idSequence);
        return idSequence.stream().map(id -> (TreeNodeShim)this.objMap.get(id)).collect(Collectors.toList());
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public Map<Long, T> getObjMap() {
        return this.objMap;
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public void setRootNode(TreeNode rootNode) {
        this.rootNode = rootNode;
    }

    public void setObjMap(Map<Long, T> objMap) {
        this.objMap = objMap;
    }

    public void setReadWriteLock(ReadWriteLock readWriteLock) {
        this.readWriteLock = readWriteLock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tree)) {
            return false;
        }
        Tree other = (Tree)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TreeNode this$rootNode = this.getRootNode();
        TreeNode other$rootNode = other.getRootNode();
        if (this$rootNode == null ? other$rootNode != null : !this$rootNode.equals(other$rootNode)) {
            return false;
        }
        Map<Long, T> this$objMap = this.getObjMap();
        Map<Long, T> other$objMap = other.getObjMap();
        return !(this$objMap == null ? other$objMap != null : !((Object)this$objMap).equals(other$objMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tree;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TreeNode $rootNode = this.getRootNode();
        result = result * 59 + ($rootNode == null ? 43 : $rootNode.hashCode());
        Map<Long, T> $objMap = this.getObjMap();
        result = result * 59 + ($objMap == null ? 43 : ((Object)$objMap).hashCode());
        return result;
    }

    public String toString() {
        return "Tree(rootNode=" + this.getRootNode() + ", objMap=" + this.getObjMap() + ", readWriteLock=" + this.getReadWriteLock() + ")";
    }
}

