/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.export;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.export.SsoExportFileService;
import java.io.File;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;

@Scope(value="prototype")
public abstract class BaseExportRunnable<T>
implements Runnable {
    private final Long taskId = new Date().getTime();
    @Autowired
    private SsoExportFileService ssoExportFileService;
    private BoundHashOperations<String, String, String> ops;
    protected Integer count;

    @PostConstruct
    public void init() {
        String key = this.ssoExportFileService.getTaskKey(this.taskId);
        StringRedisTemplate stringRedisTemplate = this.ssoExportFileService.getStringRedisTemplate();
        if (stringRedisTemplate == null) {
            throw new SsoRunTimeException("SSO\u4efb\u52a1\u4f9d\u8d56StringRedisTemplate");
        }
        this.ops = stringRedisTemplate.boundHashOps((Object)key);
        this.ops.put((Object)"successCount", (Object)"0");
        this.ops.put((Object)"count", (Object)"0");
        this.ops.put((Object)"success", (Object)"false");
        this.ops.put((Object)"url", (Object)"");
        this.ops.put((Object)"taskId", (Object)this.taskId.toString());
        stringRedisTemplate.expire((Object)key, 1L, TimeUnit.DAYS);
    }

    public Long getTaskId() {
        return this.taskId;
    }

    protected void setIncrementCount(Integer count) {
        Objects.requireNonNull(count);
        this.ops.increment((Object)"successCount", (long)count.intValue());
    }

    protected void setCount(Integer count) {
        this.ops.put((Object)"count", (Object)count.toString());
        this.count = count;
    }

    protected void setMessage(String message) {
        this.ops.put((Object)"message", (Object)message);
    }

    protected void complete(String url) {
        this.ops.put((Object)"url", (Object)url);
        this.ops.put((Object)"success", (Object)"true");
    }

    protected void error(String message) {
        this.ops.put((Object)"message", (Object)message);
        this.ops.put((Object)"success", (Object)"true");
    }

    protected File createFile(String fileName, String fileType) {
        File tempDir = this.ssoExportFileService.getTempDir();
        File file = new File(tempDir, fileName + "-" + System.currentTimeMillis() + "." + fileType);
        this.ops.put((Object)"fileName", (Object)file.getName());
        return file;
    }

    public abstract Integer submitParams(T var1);
}

