/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.logger.runnable;

import cn.com.duiba.sso.api.domain.params.SsoLogParams;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerMateInfo;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.tool.TemplateUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoLoggerRunnable
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(SsoLoggerRunnable.class);
    private SsoLoggerTheadContext context;
    private SsoLoggerMateInfo mateInfo;
    private RemoteManagerLogService remoteManagerLogService;

    @Override
    public void run() {
        List<JSONObject> paramsList = this.context.getParams();
        for (JSONObject log : paramsList) {
            try {
                JSONObject model = new JSONObject();
                model.put("oprName", (Object)this.mateInfo.getOprName());
                model.put("adminName", (Object)this.mateInfo.getOprName());
                model.putAll((Map)log);
                String logContext = TemplateUtils.replaceArgs(this.context.getTemplate(), model);
                SsoLogParams params = new SsoLogParams();
                params.setOprName(this.mateInfo.getOprName());
                params.setGroup(this.context.getGroup());
                params.setSystemId(SystemInfo.getThisSystemId());
                params.setIp(this.mateInfo.getIp());
                params.setParamsJson(log);
                params.setLogContent(logContext);
                this.remoteManagerLogService.ssoLog(params);
            }
            catch (Exception e) {
                logger.error("\u64cd\u4f5c\u65e5\u5fd7\u6253\u5370\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public SsoLoggerTheadContext getContext() {
        return this.context;
    }

    public void setContext(SsoLoggerTheadContext context) {
        this.context = context;
    }

    public SsoLoggerMateInfo getMateInfo() {
        return this.mateInfo;
    }

    public void setMateInfo(SsoLoggerMateInfo mateInfo) {
        this.mateInfo = mateInfo;
    }

    public void setRemoteManagerLogService(RemoteManagerLogService remoteManagerLogService) {
        this.remoteManagerLogService = remoteManagerLogService;
    }
}

