/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.power;

import cn.com.duiba.sso.api.common.tree.Tree;
import cn.com.duiba.sso.api.common.tree.TreeFactory;
import cn.com.duiba.sso.api.common.tree.TreeView;
import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class PowerTreeCache {
    private Tree<PowerDto> powerTree;
    private Long version = new Date().getTime();
    private HashMultimap<String, Long> urlMap;

    PowerTreeCache(Tree<PowerDto> powerTree, HashMultimap<String, Long> urlMap) {
        this.powerTree = powerTree;
        this.urlMap = urlMap;
    }

    PowerTreeCache() {
        this.powerTree = new Tree();
    }

    public Set<Long> getPowerIdsByUrl(String url) {
        return this.urlMap.get((Object)url);
    }

    public PowerDto getPower(Long powerId) {
        return this.powerTree.getNode(powerId);
    }

    public void setPowerTree(Tree<PowerDto> powerTree) {
        this.powerTree = powerTree;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public <T extends TreeView<T>> List<T> getPowerTree(Function<PowerDto, T> transform) {
        List<PowerDto> nodeList = this.powerTree.getTreeView();
        ArrayList list = Lists.newArrayList();
        for (PowerDto power : nodeList) {
            TreeView node = (TreeView)transform.apply(power);
            if (node.getId() == null || node.getParentId() == null) {
                throw new SsoRunTimeException("Function\u8f6c\u5316\u65b9\u6cd5\u5fc5\u987b\u5b8c\u6210Id\u548cparentId\u7684\u8f6c\u5316");
            }
            list.add(node);
        }
        Tree tree = TreeFactory.createTree(list);
        return TreeFactory.transformTree(tree);
    }

    public List<PowerDto> getPowerWay(Long powerId) {
        return this.powerTree.getOneWayView(powerId);
    }

    public Long getVersion() {
        return this.version;
    }

    public Tree<PowerDto> getPowerTree() {
        return this.powerTree;
    }

    public HashMultimap<String, Long> getUrlMap() {
        return this.urlMap;
    }

    public void setUrlMap(HashMultimap<String, Long> urlMap) {
        this.urlMap = urlMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerTreeCache)) {
            return false;
        }
        PowerTreeCache other = (PowerTreeCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Tree<PowerDto> this$powerTree = this.getPowerTree();
        Tree<PowerDto> other$powerTree = other.getPowerTree();
        if (this$powerTree == null ? other$powerTree != null : !((Object)this$powerTree).equals(other$powerTree)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        HashMultimap<String, Long> this$urlMap = this.getUrlMap();
        HashMultimap<String, Long> other$urlMap = other.getUrlMap();
        return !(this$urlMap == null ? other$urlMap != null : !this$urlMap.equals(other$urlMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PowerTreeCache;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Tree<PowerDto> $powerTree = this.getPowerTree();
        result = result * 59 + ($powerTree == null ? 43 : ((Object)$powerTree).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        HashMultimap<String, Long> $urlMap = this.getUrlMap();
        result = result * 59 + ($urlMap == null ? 43 : $urlMap.hashCode());
        return result;
    }

    public String toString() {
        return "PowerTreeCache(powerTree=" + this.getPowerTree() + ", version=" + this.getVersion() + ", urlMap=" + this.getUrlMap() + ")";
    }
}

