package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.enums.AdminIdentity;
import cn.com.duiba.sso.api.domain.params.DimissionParams;
import cn.com.duiba.sso.api.domain.params.EntryParams;

/**
 * 人事接口
 */
@AdvancedFeignClient
public interface RemotePersonalService {

    /**
     * 根据员工名称创建一个账号名
     * @param adminName 员工姓名
     * @return 账号
     */
    String createAccount(String adminName);

    /**
     * 入职
     * @param entryParams 入职申请
     * @return 员工Id
     */
    Long entry(EntryParams entryParams) throws BizException;

    /**
     * 离职
     * @param params 离职请求
     * @throws BizException 员工存在某种职权的绑定，需要解除才能进行离职
     */
    void staffDimission(DimissionParams params)throws BizException;;

    /**
     * 由adminId获取该用户admin信息，包括离职人员
     */
    AdminDto findStaffInfo(Long adminId);

    /**
     * 设置员工身份
     * @param adminId 员工id
     * @param adminIdentity 员工身份
     */
    void setupAdminIdentity(Long adminId, AdminIdentity adminIdentity) throws BizException;

}
