package cn.com.duiba.sso.api.service.power;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import lombok.Data;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

/**
 * 管理员的权限缓存
 */
@Data
public class PowerCache {

    private AtomicLong version;

    private Set<Long> powerIdSet = Sets.newHashSet();

    PowerCache(Long version){
        this.version =  new AtomicLong(version);
    }

    PowerCache(){
        this.version =  new AtomicLong(System.currentTimeMillis());
    }


    /**
     * 返回所有的白名单(用于页面元素匹配)
     * @return
     */
    public Set<Long> getPowerIdSet(){
        return ImmutableSet.copyOf(powerIdSet);
    }

    /**
     * 设置管理员所有角色Id
     * @param roleIdSet
     */
    protected void setPowerIdSet(Set<Long> roleIdSet) {
        this.powerIdSet.addAll(roleIdSet);
    }

    protected Long getVersion() {
        return this.version.get();
    }

    protected void setVersion(Long version) {
        this.version.set(version);
    }

}
