package cn.com.duiba.sso.api.service.power;

import cn.com.duiba.sso.api.tool.SystemInfo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.util.*;

@Slf4j
public class SsoResourceFieldFilter {

    private Map<Class,ResourceFieldDescription> ResourceFieldDescriptions = Maps.newConcurrentMap();

    @Resource
    private AdminPowerCacheService adminPowerCacheService;
    @Resource
    private PowerTreeService powerTreeService;

    public void doFilter(Long adminId,Collection collection){
        if(collection.isEmpty()){
            return;
        }
        PowerCache powerCache = adminPowerCacheService.getPowerCache(adminId);
        PowerTreeCache powerTreeCache = powerTreeService.getPowerTreeCache(SystemInfo.getThisSystemId());
        for(Object item:collection){
            ResourceFieldDescription description = buildResourceFieldDescription(item.getClass());
            Map<Field, String> replaceMap = description.getReplaceMap();
            for(Map.Entry<Field,SsoResourceField> entrys:description.getAnnotationMap().entrySet()){

                Object value = getField(entrys.getKey(),item);
                if(Objects.isNull(value)){
                    continue;
                }
                SsoResourceField resourceField = entrys.getValue();
                Set<Long> powerIds =  powerTreeCache.getPowerIdsByUrl(resourceField.value());

                boolean hasPower = powerIds.isEmpty() || !Sets.intersection(powerIds,powerCache.getPowerIdSet()).isEmpty();
                boolean isCollection = value instanceof Collection;

                if(isCollection && !hasPower){
                    ((Collection)value).clear();
                }
                if(isCollection && hasPower){
                    doFilter(adminId,(Collection)value);
                }
                if(!isCollection && !hasPower){
                    try{
                        Object replace = replaceMap.getOrDefault(entrys.getKey(), null);
                        FieldUtils.writeField(entrys.getKey(),item,replace,true);
                    }catch (Exception e){
                        log.error("字段替换异常",e);
                    }
                }
            }
        }
    }


    private ResourceFieldDescription buildResourceFieldDescription(Class clazz){
        if(ResourceFieldDescriptions.containsKey(clazz)){
            return ResourceFieldDescriptions.get(clazz);
        }
        synchronized (this){
            if(ResourceFieldDescriptions.containsKey(clazz)){
                return ResourceFieldDescriptions.get(clazz);
            }

            ResourceFieldDescription description = new ResourceFieldDescription();
            List<Field> fields = FieldUtils.getAllFieldsList(clazz);

            for(Field field:fields){
                SsoResourceField resourceField = field.getAnnotation(SsoResourceField.class);
                if(Objects.isNull(resourceField)){
                    continue;
                }
                description.putSsoResourceField(field,resourceField);
            }
            ResourceFieldDescriptions.put(clazz,description);
            return description;
        }
    }

    private Object getField(Field field,Object object){
        try{
            return FieldUtils.readField(field,object,true);
        }catch (Exception e){
            throw new RuntimeException(e);
        }
    }

}
