package cn.com.duiba.sso.api.mappingmode;

import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

import java.util.HashMap;
import java.util.Map;

/**
 * 兼容老版本的映射模式
 */
public class SsoMappingModeEnvApplicationInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext>, Ordered {

    @Override
    public void initialize(ConfigurableApplicationContext application) {

        ConfigurableEnvironment environment = application.getEnvironment();

        MutablePropertySources mutablePropertySources = environment.getPropertySources();

        String appName = environment.getProperty("spring.application.name");
        if(StringUtils.equals("sso-service",appName)){
            return;
        }

        Map<String, Object> baseConfig = new HashMap<>();
        PropertySource<?> basePropertySource = new MapPropertySource("ssoBaseConfig",baseConfig);
        mutablePropertySources.addFirst(basePropertySource);

        baseConfig.put("application.boot.oauth.host","https://oauth.dui88.com");
        String environmentForConfig = environment.getProperty("duiba.sso.environment","");
        if(StringUtils.isNotBlank(environmentForConfig)){
            baseConfig.put("spring.application.environment",environmentForConfig);
        }

        String appSecret = environment.getProperty("duiba.sso.app-secret");
        String secret = environment.getProperty("spring.application.secret");

        if(StringUtils.isBlank(secret) && StringUtils.isNotBlank(appSecret)){
            baseConfig.put("spring.application.secret",appSecret);
        }

    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE + 10;
    }
}
