/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service;

import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoApplicationService {
    private static final Logger log = LoggerFactory.getLogger(SsoApplicationService.class);
    @Resource
    private RemoteApplicationService remoteApplicationService;
    private LoadingCache<String, ApplicationDto> cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(systemName -> {
        ApplicationDto application = this.remoteApplicationService.getApplicationByAlias(systemName);
        if (application == null) {
            log.error("systemName:" + systemName + "\u6ca1\u6709\u5bf9\u5e94\u7684\u7cfb\u7edf\u914d\u7f6e");
        }
        return application;
    });

    public ApplicationDto getSystemByAlias(String systemAlias) {
        return (ApplicationDto)this.cache.get((Object)systemAlias);
    }
}

