package cn.com.duiba.sso.api.domain.enums;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ResourceType {

    POWER(1) {

        @Override
        public void verify(String resourceText) {
            if(StringUtils.isBlank(resourceText)){
                throw new SsoRunTimeException("权限内容不能为空");
            }
        }
    },
    JSON(2) {
        @Override
        public void verify(String resourceText) {
            JSONObject json;
            try{
                json = JSONObject.parseObject(resourceText);
            }catch (Exception e){
                logger.debug("资源内容不符合JSON格式",e);
                throw new SsoRunTimeException("资源内容不符合JSON格式");
            }
            if(json.containsKey(POWER_KEYS)){
                POWER.verify(json.getString(POWER_KEYS));
            }
        }
    };


    private static Logger logger = LoggerFactory.getLogger(ResourceType.class);

    public static final String POWER_KEYS = "keys";

    public static ResourceType getResourceType(Integer type){
        switch (type){
            case 1:return POWER;
            case 2:return JSON;
            default:throw new SsoRunTimeException("非有效的资源类型");
        }
    }

    private final Integer type;

    ResourceType(Integer type){
        this.type = type;
    }

    public Integer getType() {
        return type;
    }

    public abstract void verify(String resourceText);




}
