/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool;

import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.sso.api.common.interfaces.AppInterfaceAnalysisService;
import cn.com.duiba.sso.api.domain.params.ApplicationInfoParams;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.sso.api.service.SsoApplicationService;
import cn.com.duiba.sso.api.tool.SsoVersion;
import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class SystemInfo {
    private static final Logger log = LoggerFactory.getLogger(SystemInfo.class);
    private static SsoApplicationService ssoSystemService;
    private static RemoteSystemService remoteSystemService;
    private static ApplicationProperties applicationProperties;
    @Resource
    private AppInterfaceAnalysisService appInterfaceAnalysisService;
    @Resource
    private Environment currentEnvironment;

    @EventListener(value={MainContextRefreshedEvent.class})
    public void mainContextRefreshedEventListener() {
        try {
            if (Objects.equals(this.currentEnvironment, Environment.DEV)) {
                remoteSystemService.checkAppVersion(DuibaBootVersion.getVersion(), SsoVersion.getVersion());
            }
            String version = SsoVersion.getVersion();
            ApplicationInfoParams params = new ApplicationInfoParams();
            params.setAppName(applicationProperties.getName());
            params.setVersion(version);
            params.setProfiles(this.currentEnvironment.getEnvId());
            remoteSystemService.submitApplicationInfoParams(params);
            this.appInterfaceAnalysisService.gatherAppInterfaceInfo();
        }
        catch (Exception e) {
            log.error("\u5411SSO\u63d0\u4ea4\u5e94\u7528\u539f\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public static ApplicationDto getThisSystemInfo() {
        return ssoSystemService.getSystemByAlias(applicationProperties.getApplicationName());
    }

    public static Long getThisSystemId() {
        ApplicationDto system = SystemInfo.getThisSystemInfo();
        if (system == null) {
            throw new SsoRunTimeException("\u6ca1\u6709\u68c0\u7d22\u5230" + applicationProperties.getApplicationName() + "\u5bf9\u5e94\u7684\u7cfb\u7edf\u914d\u7f6e");
        }
        return system.getId();
    }

    @Autowired
    public void setRemoteSystemService(RemoteSystemService remoteSystemService) {
        SystemInfo.remoteSystemService = remoteSystemService;
    }

    @Autowired
    public void setSsoSystemService(SsoApplicationService ssoSystemService) {
        SystemInfo.ssoSystemService = ssoSystemService;
    }

    @Autowired
    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        SystemInfo.applicationProperties = applicationProperties;
    }

    public static String getSystemAlias() {
        return applicationProperties.getApplicationName();
    }
}

