package cn.com.duiba.sso.api.service.logger.service;

import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.service.logger.SsoLogger;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerStackContext;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.service.logger.runnable.SsoLoggerRunnable;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

/**
 * Created by liuyao on 2017/6/19.
 */
public class SsoLoggerService implements InitializingBean {

    @Resource(name= "ssoExecutorService")
    private ExecutorService ssoExecutorService;
    @Resource
    private RemoteManagerLogService remoteManagerLogService;
    @Autowired(required = false)
    private SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter;

    /**
     * 由切面产生,如果没有此日志线程对象,则SsoLogger的无法打印日志
     */
    private ThreadLocal<SsoLoggerStackContext> threadContext = new ThreadLocal<>();

    /**
     * 打印日志
     * @param json
     */
    public void log(JSONObject json){
        Objects.requireNonNull(json);
        SsoLoggerStackContext context = threadContext.get();
        if(context==null){
            return;
        }
        context.addLogParams(json);
    }

    public SsoLoggerStackContext initStackContext(){
        SsoLoggerStackContext context = threadContext.get();
        if(context==null){
            context = new SsoLoggerStackContext();
            threadContext.set(context);
        }
        return context;
    }


    /**
     *
     * @param context
     */
    public void setThreadContext(SsoLoggerTheadContext context){
        SsoLoggerStackContext stackContext = initStackContext();
        if(stackContext==null){
            return;
        }
        stackContext.addContext(context);
    }

    /**
     * 打印业务日志
     */
    public void flushThreadContext(){
        if(ssoLoggerMateInfoAdapter==null){
            return;
        }
        SsoLoggerStackContext context = threadContext.get();
        if(Objects.equals(null,context)){
            return;
        }

        //克隆出一个 RequestParams
        SsoLoggerTheadContext theadContext = context.popContext();

        SsoLoggerRunnable runnable = new SsoLoggerRunnable();
        runnable.setMateInfo(ssoLoggerMateInfoAdapter.getLoggerMateInfo());
        runnable.setContext(theadContext);
        runnable.setRemoteManagerLogService(remoteManagerLogService);
        ssoExecutorService.submit(runnable);
        if (context.isEmpty()){
            threadContext.remove();
        }
    }

    @Override
    public void afterPropertiesSet(){
        SsoLogger.setSsoLoggerService(this);
    }

}
