package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.AdminInfoDto;

import java.util.List;

/**
 *
 * @author liuyao
 * @date 2017/5/12
 */
@AdvancedFeignClient
public interface RemoteAdminService {

    /**
     * 查询单个员工信息
     * @throws BizException 员工已经离职
     */
    AdminDto findOneAdmin(Long id) throws BizException;

    /**
     * 根据邮箱获取管理员信息
     * @throws BizException 员工已经离职
     */
    AdminDto findByEmail(String email) throws BizException;

    /**
     * 查询员工简要的信息，此方法可以查询所有的员工，包括离职
     * @param id 员工Id
     */
    AdminInfoDto findSimpleAdminInfo(Long id);

    /**
     * 获取员工简要的信息，包括离职
     * @param account 账号
     * @return 员工信息
     */
    AdminInfoDto findSimpleAdminInfoByAccount(String account);

    /**
     * 根据手机号码查询用户
     * @param mobile 手机号码 11位
     * @return 用户基础信息
     */
    AdminInfoDto findSimpleAdminByMobile(String mobile);

    /**
     * 按系统和角色名称检索管理员
     * @param systemId 应用Id
     * @param roleName 角色名称，如果为null，则查询拥有该系统权限所有的人员
     */
    List<AdminDto> findAdminsByRoleName(Long systemId,String roleName);

    /**
     * 查出拥有权限所有管理员
     */
    List<AdminDto> findAdminsByPowerIds(Long systemId, List<Long> powerIds);

    /**
     * 验证谷歌动态码
     */
    Boolean googleCodeVerify(Long adminId,String code);

    /**
     * 批量查询管理员
     */
    List<AdminDto> batchFindAdminByIds(List<Long> ids);

    /**
     * 批量查询员工信息，包括离职
     */
    List<AdminInfoDto> batchFindAdminInfoByIds(List<Long> ids);

    /**
     * 根据角色ID查询所有的管理员
     */
    List<AdminDto> findAdminByRoleIds(List<Long> roleIds);

    /**
     * 根据姓名或者账号拼音去匹配员工列表
     */
    List<AdminDto> findByNameLike(String adminName);

}
