package cn.com.duiba.sso.api.service.power;

import com.google.common.collect.Maps;
import lombok.Data;

import java.lang.reflect.Field;
import java.util.Map;

@Data
class ResourceFieldDescription {

    private Class clazz;

    private Map<Field, SsoResourceField> annotationMap = Maps.newHashMap();

    private Map<Field, String> replaceMap = Maps.newHashMap();

    void putSsoResourceField(Field field, SsoResourceField ssoResourceField){
        annotationMap.put(field,ssoResourceField);
        if(CharSequence.class.isAssignableFrom(field.getType())){
            replaceMap.put(field,ssoResourceField.replace());
        }
    }

}
