/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.logger;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.logger.SsoLogger;
import cn.com.duiba.sso.api.service.logger.annotation.SsoLoggerMethod;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerTheadContext;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SsoLoggerInterceptor {
    @Pointcut(value="@annotation(cn.com.duiba.sso.api.service.logger.annotation.SsoLoggerMethod)")
    public void logger() {
    }

    @Before(value="logger()")
    public void loggerBefore(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        SsoLoggerMethod ssoLoggerMethod = (SsoLoggerMethod)AnnotationUtils.findAnnotation((Method)method, SsoLoggerMethod.class);
        String template = ssoLoggerMethod.value();
        String group = ssoLoggerMethod.group();
        if (StringUtils.isBlank((String)template)) {
            throw new SsoRunTimeException("SSO\u64cd\u4f5c\u65e5\u5fd7\uff1a" + group + "\uff0ctemplate\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SsoLoggerTheadContext context = new SsoLoggerTheadContext();
        context.setTemplate(template);
        context.setGroup(group);
        SsoLogger.setSsoLoggerTheadContext(context);
    }

    @After(value="logger()")
    public void loggerAfter() {
        SsoLogger.flush();
    }
}

