/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.power;

import cn.com.duiba.sso.api.service.power.AdminPowerCacheService;
import cn.com.duiba.sso.api.service.power.PowerCache;
import cn.com.duiba.sso.api.service.power.PowerTreeCache;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.service.power.ResourceFieldDescription;
import cn.com.duiba.sso.api.service.power.SsoResourceField;
import cn.com.duiba.sso.api.tool.SystemInfo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoResourceFieldFilter {
    private static final Logger log = LoggerFactory.getLogger(SsoResourceFieldFilter.class);
    private Map<Class, ResourceFieldDescription> ResourceFieldDescriptions = Maps.newConcurrentMap();
    @Resource
    private AdminPowerCacheService adminPowerCacheService;
    @Resource
    private PowerTreeService powerTreeService;

    public void doFilter(Long adminId, Collection collection) {
        if (collection.isEmpty()) {
            return;
        }
        PowerCache powerCache = this.adminPowerCacheService.getPowerCache(adminId);
        PowerTreeCache powerTreeCache = this.powerTreeService.getPowerTreeCache(SystemInfo.getThisSystemId());
        for (Object item : collection) {
            ResourceFieldDescription description = this.buildResourceFieldDescription(item.getClass());
            Map<Field, String> replaceMap = description.getReplaceMap();
            for (Map.Entry<Field, SsoResourceField> entrys : description.getAnnotationMap().entrySet()) {
                Object value = this.getField(entrys.getKey(), item);
                if (Objects.isNull(value)) continue;
                SsoResourceField resourceField = entrys.getValue();
                Set<Long> powerIds = powerTreeCache.getPowerIdsByUrl(resourceField.value());
                boolean hasPower = powerIds.isEmpty() || !Sets.intersection(powerIds, powerCache.getPowerIdSet()).isEmpty();
                boolean isCollection = value instanceof Collection;
                if (isCollection && !hasPower) {
                    ((Collection)value).clear();
                }
                if (isCollection && hasPower) {
                    this.doFilter(adminId, (Collection)value);
                }
                if (isCollection || hasPower) continue;
                try {
                    Object replace = replaceMap.getOrDefault(entrys.getKey(), null);
                    FieldUtils.writeField((Field)entrys.getKey(), item, replace, (boolean)true);
                }
                catch (Exception e) {
                    log.error("\u5b57\u6bb5\u66ff\u6362\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceFieldDescription buildResourceFieldDescription(Class clazz) {
        if (this.ResourceFieldDescriptions.containsKey(clazz)) {
            return this.ResourceFieldDescriptions.get(clazz);
        }
        SsoResourceFieldFilter ssoResourceFieldFilter = this;
        synchronized (ssoResourceFieldFilter) {
            if (this.ResourceFieldDescriptions.containsKey(clazz)) {
                return this.ResourceFieldDescriptions.get(clazz);
            }
            ResourceFieldDescription description = new ResourceFieldDescription();
            List fields = FieldUtils.getAllFieldsList((Class)clazz);
            for (Field field : fields) {
                SsoResourceField resourceField = field.getAnnotation(SsoResourceField.class);
                if (Objects.isNull(resourceField)) continue;
                description.putSsoResourceField(field, resourceField);
            }
            this.ResourceFieldDescriptions.put(clazz, description);
            return description;
        }
    }

    private Object getField(Field field, Object object) {
        try {
            return FieldUtils.readField((Field)field, (Object)object, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

