/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.common.interfaces.AppInterfaceAnalysisConfiguration;
import cn.com.duiba.sso.api.service.SsoApplicationService;
import cn.com.duiba.sso.api.service.logger.SsoLoggerConfiguration;
import cn.com.duiba.sso.api.service.power.AdminPowerCacheService;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.service.power.SsoResourceFieldFilter;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.threadpool.policy.AbortPolicyWithReport;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@Import(value={AppInterfaceAnalysisConfiguration.class, SsoLoggerConfiguration.class})
public class SsoBasicConfiguration {
    @Bean
    public SystemInfo initSysytem() {
        return new SystemInfo();
    }

    @Bean
    public SsoApplicationService ssoSystemService() {
        return new SsoApplicationService();
    }

    @Bean
    public PowerTreeService powerTreeService() {
        return new PowerTreeService();
    }

    @Bean
    public SsoResourceFieldFilter ssoResourceFieldFilter() {
        return new SsoResourceFieldFilter();
    }

    @Bean
    public AdminPowerCacheService adminPowerCacheService() {
        return new AdminPowerCacheService();
    }

    @Bean
    public ExecutorService ssoExecutorService() {
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(500);
        return new ThreadPoolExecutor(10, 40, 60L, TimeUnit.SECONDS, queue, (ThreadFactory)new NamedThreadFactory("sso"), (RejectedExecutionHandler)new AbortPolicyWithReport());
    }
}

