/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.common.tree;

import cn.com.duiba.sso.api.common.tree.TreeNode;
import cn.com.duiba.sso.api.common.tree.TreeNodeShim;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Tree<T extends TreeNodeShim>
implements Serializable {
    private final TreeNode rootNode;
    private final Map<Long, T> objMap = Maps.newHashMap();

    public Tree() {
        this.rootNode = new TreeNode(0L, TreeNode.VIRTUAL_PARENT_ID);
    }

    public Tree(Long rootId) {
        this.rootNode = new TreeNode(rootId, TreeNode.VIRTUAL_PARENT_ID);
    }

    public boolean containsId(Long id) {
        return this.rootNode.containsId(id);
    }

    public int size() {
        return this.rootNode.getChildSize();
    }

    public void addNode(T shim) {
        TreeNode node = new TreeNode((TreeNodeShim)shim);
        this.rootNode.addChildNode(node);
        ((TreeNodeShim)shim).setLevel(node.getLevel());
        this.objMap.put(((TreeNodeShim)shim).getId(), shim);
    }

    public void deleteNode(Long nodeId) throws Exception {
        if (this.rootNode.containsId(nodeId)) {
            this.rootNode.deleteChildNode(nodeId);
            this.objMap.remove(nodeId);
        }
    }

    public List<T> getTreeView() {
        List<TreeNode> list = this.rootNode.getAllNode();
        return list.stream().map(node -> (TreeNodeShim)this.objMap.get(node.getId())).collect(Collectors.toList());
    }

    public T getNode(Long nodeId) {
        return (T)((TreeNodeShim)this.objMap.get(nodeId));
    }

    public List<T> getOneWayView(Long destNodeId) {
        ArrayList idSequence = Lists.newArrayList();
        this.rootNode.findNodeWay(destNodeId, idSequence);
        return idSequence.stream().map(this.objMap::get).collect(Collectors.toList());
    }
}

