/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.domain.enums;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ResourceType {
    POWER(1){

        @Override
        public void verify(String resourceText) {
            if (StringUtils.isBlank((String)resourceText)) {
                throw new SsoRunTimeException("\u6743\u9650\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
    ,
    JSON(2){

        @Override
        public void verify(String resourceText) {
            JSONObject json;
            try {
                json = JSONObject.parseObject((String)resourceText);
            }
            catch (Exception e) {
                log.debug("\u8d44\u6e90\u5185\u5bb9\u4e0d\u7b26\u5408JSON\u683c\u5f0f", (Throwable)e);
                throw new SsoRunTimeException("\u8d44\u6e90\u5185\u5bb9\u4e0d\u7b26\u5408JSON\u683c\u5f0f");
            }
            if (json.containsKey((Object)ResourceType.POWER_KEYS)) {
                POWER.verify(json.getString(ResourceType.POWER_KEYS));
            }
        }
    };

    private static final Logger log;
    public static final String POWER_KEYS = "keys";
    private final Integer type;

    public static ResourceType getResourceType(Integer type) {
        switch (type) {
            case 1: {
                return POWER;
            }
            case 2: {
                return JSON;
            }
        }
        throw new SsoRunTimeException("\u975e\u6709\u6548\u7684\u8d44\u6e90\u7c7b\u578b");
    }

    private ResourceType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }

    public abstract void verify(String var1);

    static {
        log = LoggerFactory.getLogger(ResourceType.class);
    }
}

