/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.logger.service;

import cn.com.duiba.sso.api.domain.params.OprLogParams;
import cn.com.duiba.sso.api.service.logger.appender.SsoLogAppender;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerStackFrame;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.tool.TemplateUtils;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoLoggerRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SsoLoggerRunnable.class);
    private SsoLoggerStackFrame stackFrame;
    private List<SsoLogAppender> logAppenders;

    @Override
    public void run() {
        JSONObject model = this.stackFrame.getParams();
        String logContext = TemplateUtils.replaceArgs(this.stackFrame.getTemplate(), model);
        OprLogParams params = new OprLogParams();
        params.setAppId(SystemInfo.getThisSystemId());
        params.setAdminId(this.stackFrame.getAdminId());
        params.setGroup(this.stackFrame.getGroup());
        params.setIp(this.stackFrame.getIp());
        params.setParams(model.toJSONString());
        params.setLogContent(logContext);
        params.setActionTime(new Date());
        for (SsoLogAppender appender : this.logAppenders) {
            try {
                OprLogParams clone = new OprLogParams();
                BeanUtils.copy((Object)params, (Object)clone);
                appender.acceptOperationLog(params);
            }
            catch (Exception e) {
                log.error("Class[{}]\u5904\u7406\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25", (Object)appender.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    public void setLogAppenders(List<SsoLogAppender> logAppenders) {
        this.logAppenders = logAppenders;
    }

    public void setStackFrame(SsoLoggerStackFrame stackFrame) {
        this.stackFrame = stackFrame;
    }
}

