/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.logger.service;

import cn.com.duiba.sso.api.service.logger.SsoLogger;
import cn.com.duiba.sso.api.service.logger.appender.SsoLogAppender;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerMateInfo;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerStackFrame;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerRunnable;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerStackContext;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class SsoLoggerService
implements InitializingBean {
    @Resource(name="ssoExecutorService")
    private ExecutorService ssoExecutorService;
    @Autowired(required=false)
    private SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter;
    @Autowired
    private List<SsoLogAppender> ssoLogAppenderList;
    private final ThreadLocal<SsoLoggerStackContext> threadContext = new ThreadLocal();

    public void afterPropertiesSet() {
        SsoLogger.setSsoLoggerService(this);
    }

    protected void initStackContext(SsoLoggerStackFrame frame) {
        SsoLoggerStackContext context = this.threadContext.get();
        if (Objects.isNull(context)) {
            context = new SsoLoggerStackContext();
            this.threadContext.set(context);
        }
        context.addStackFrame(frame);
    }

    public SsoLoggerStackContext getSsoLoggerStackContext() {
        SsoLoggerStackContext context = this.threadContext.get();
        if (Objects.isNull(context)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u4f4d\u4e8eSso\u64cd\u4f5c\u65e5\u5fd7\u5207\u9762\u4e2d");
        }
        return context;
    }

    protected void flushThreadContext() {
        SsoLoggerStackContext stackContext = this.threadContext.get();
        if (Objects.isNull(stackContext)) {
            return;
        }
        SsoLoggerStackFrame frame = stackContext.popStackFrame();
        if (stackContext.isEmpty()) {
            this.threadContext.remove();
        }
        if (Objects.isNull(frame)) {
            return;
        }
        if (this.ssoLoggerMateInfoAdapter == null) {
            return;
        }
        SsoLoggerMateInfo mateInfo = this.ssoLoggerMateInfoAdapter.getLoggerMateInfo();
        frame.setIp(mateInfo.getIp());
        frame.setAdminId(mateInfo.getAdminId());
        SsoLoggerRunnable runnable = new SsoLoggerRunnable();
        runnable.setStackFrame(frame);
        runnable.setLogAppenders(this.ssoLogAppenderList);
        this.ssoExecutorService.submit(runnable);
    }
}

