/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.power;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.service.power.PowerCache;
import cn.com.duiba.sso.api.service.power.PowerTreeCache;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.tool.SystemInfo;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class AdminPowerCacheService {
    private static final Logger log = LoggerFactory.getLogger(AdminPowerCacheService.class);
    private final LoadingCache<Long, PowerCache> adminPowerCache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new AdminRoleCacheLoader());
    @Autowired
    private RemotePermissionService remotePermissionService;
    @Autowired
    private PowerTreeService powerTreeService;
    @Autowired
    private RemoteAdminService remoteAdminService;

    public List<AdminDto> getHasPowerAdmins(String powerPath) {
        PowerTreeCache cache = this.powerTreeService.getPowerTreeCache(SystemInfo.getThisSystemId());
        Set<Long> pawerIds = cache.getPowerIdsByUrl(powerPath);
        if (pawerIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.remoteAdminService.findAdminsByPowerIds(SystemInfo.getThisSystemId(), Lists.newArrayList(pawerIds));
    }

    PowerCache getPowerCache(Long adminId) {
        return (PowerCache)this.adminPowerCache.get((Object)adminId);
    }

    public Boolean hasPower(Long adminId, String powerPath) {
        PowerTreeCache powerTreeCache = this.powerTreeService.getPowerTreeCache(SystemInfo.getThisSystemId());
        Set<Long> pawerIds = powerTreeCache.getPowerIdsByUrl(powerPath);
        if (pawerIds.isEmpty()) {
            return true;
        }
        PowerCache cache = this.getPowerCache(adminId);
        return !Sets.intersection(pawerIds, cache.getPowerIdSet()).isEmpty();
    }

    public Set<Long> hasPowerIds(Long adminId, String powerPath) {
        PowerTreeCache powerTreeCache = this.powerTreeService.getPowerTreeCache(SystemInfo.getThisSystemId());
        Set<Long> pawerIds = powerTreeCache.getPowerIdsByUrl(powerPath);
        if (pawerIds.isEmpty()) {
            return Collections.emptySet();
        }
        PowerCache cache = this.getPowerCache(adminId);
        return Sets.intersection(pawerIds, cache.getPowerIdSet());
    }

    public Set<String> getAllPowerRes(Long adminId) {
        PowerCache cache = this.getPowerCache(adminId);
        Set<Long> powerIds = cache.getPowerIdSet();
        HashSet urlSet = Sets.newHashSet();
        PowerTreeCache powerTreeCache = this.powerTreeService.getPowerTreeCache(SystemInfo.getThisSystemId());
        for (Long id : powerIds) {
            PowerDto power = powerTreeCache.getPower(id);
            if (power == null) continue;
            urlSet.addAll(power.getUrls());
        }
        return urlSet;
    }

    public Long version(Long adminId) {
        PowerCache cache = this.getPowerCache(adminId);
        return cache.getVersion();
    }

    public void clean(Long adminId) {
        this.adminPowerCache.invalidate((Object)adminId);
    }

    @Scheduled(cron="0/15 0/1 * * * ?")
    public void adminPowerFlushTask() {
        try {
            Long systemId = SystemInfo.getThisSystemId();
            Set adminIds = this.adminPowerCache.asMap().keySet();
            for (Long adminId : adminIds) {
                PowerCache cache = (PowerCache)this.adminPowerCache.getIfPresent((Object)adminId);
                if (cache == null) continue;
                Long version = this.remotePermissionService.getAdminPowerVersion(systemId, adminId);
                if (cache.getVersion() >= version) continue;
                this.adminPowerCache.invalidate((Object)adminId);
            }
        }
        catch (Exception e) {
            log.error("\u7ba1\u7406\u5458\u6743\u9650\u68c0\u6d4b\u5931\u8d25", (Throwable)e);
        }
    }

    private class AdminRoleCacheLoader
    implements CacheLoader<Long, PowerCache> {
        private AdminRoleCacheLoader() {
        }

        public PowerCache load(Long adminId) {
            Long systemId = SystemInfo.getThisSystemId();
            Set<Long> powerIds = AdminPowerCacheService.this.remotePermissionService.getPowerIdsBySystemIdAndAdminId(systemId, adminId);
            PowerCache cache = new PowerCache(AdminPowerCacheService.this.remotePermissionService.getAdminPowerVersion(systemId, adminId));
            cache.setPowerIdSet(powerIds);
            return cache;
        }
    }
}

