package cn.com.duiba.sso.api.service.logger;

import cn.com.duiba.sso.api.service.logger.service.SsoLoggerStackContext;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerService;
import com.alibaba.fastjson.JSONObject;

import java.util.Map;
import java.util.Objects;

/**
 *
 * @author liuyao
 * @date 2017/6/19
 * 管理员日志打印者
 */
public class SsoLogger {

    private static volatile SsoLoggerService ssoLoggerService;

    /**
     * 通过json渲染日志
     */
    public static SsoLoggerStackContext addLogParams(JSONObject json) {
        Objects.requireNonNull(json);
        SsoLoggerStackContext context = ssoLoggerService.getSsoLoggerStackContext();
        context.addLogParam(json);
        return context;
    }

    public static SsoLoggerStackContext addLogParams(String key,Object value){
        SsoLoggerStackContext context = ssoLoggerService.getSsoLoggerStackContext();
        context.addLogParam(key,value);
        return context;
    }

    /**
     * 根据简单打印日志,简单类将被JSON序列化
     */
    public static SsoLoggerStackContext logForPojo(Object params){
        Objects.requireNonNull(params);
        JSONObject json = new JSONObject();
        if(params instanceof Map){
            json.putAll((Map)params);
        }else{
            String jsonStr = JSONObject.toJSONString(params);
            json.putAll(JSONObject.parseObject(jsonStr));
        }
        SsoLoggerStackContext context = ssoLoggerService.getSsoLoggerStackContext();
        context.addLogParam(json);
        return context;
    }

    /**
     * 通过json渲染日志
     * use SsoLogger.addLogParams()
     */
    public static SsoLoggerStackContext logForJson(JSONObject params){
        Objects.requireNonNull(params);
        SsoLoggerStackContext context = ssoLoggerService.getSsoLoggerStackContext();
        context.addLogParam(params);
        return context;
    }

    public static void setSsoLoggerService(SsoLoggerService ssoLoggerService) {
        SsoLogger.ssoLoggerService = ssoLoggerService;
    }
}
