package cn.com.duiba.sso.api.service.logger.domain;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

/**
 * 日志栈帧
 * @author liuyao
 */
@Data
public class SsoLoggerStackFrame {

    /**
     * 模版参数
     */
    private final JSONObject params = new JSONObject();
    /**
     * 日志模版
     */
    private String template;
    /**
     * 模块名称
     */
    private String group;

    /**
     * 系统级别租户纬度字段
     */
    private Long adminId;
    /**
     * 提交
     */
    private String ip;
    /**
     * 是否异常日志
     */
    private boolean errorLog = false;

    public void addParam(JSONObject param) {
        this.params.putAll(param);
    }

    public void addParam(String key, Object value) {
        this.params.put(key, value);
    }

}
